<?php

/*
 * Plugin Name: WP OS Backend Desktop
 * Version: 1.160
 * Plugin URI: http://codecanyon.net/user/loopus/portfolio
 * Description: This plugin gives a beautiful OS desktop style to your WP Backend
 * Author: Biscay Charly (loopus)
 * Author URI: http://www.loopus-plugins.com/
 * Requires at least: 3.8
 * Tested up to: 6.5
 *
 * @package WordPress
 * @author Biscay Charly (loopus)
 * @since 1.0.0
 */

if (!defined('ABSPATH'))
    exit;

register_activation_hook(__FILE__, 'wos_install');
register_uninstall_hook(__FILE__, 'wos_uninstall');

global $jal_db_version;
$jal_db_version = "1.1";

require_once('includes/wos_core.php');
require_once('includes/wos_admin.php');

function wos_osBackendDesktop() {
    $version = 1.160;
    wos_checkDBUpdates($version);
    $instance = wos_core::instance(__FILE__, $version);
    if (is_null($instance->menu)) {
        $instance->menu = wos_admin::instance($instance);
    }
    return $instance;
}

/**
 * Installation. Runs on activation.
 * @access  public
 * @since   1.0.0
 * @return  void
 */
function wos_install() {
    global $wpdb;
    global $jal_db_version;
    require_once(ABSPATH . '/wp-admin/includes/upgrade.php');
    add_option("jal_db_version", $jal_db_version);

    $db_table_name = $wpdb->prefix . "wos_settings";
    if ($wpdb->get_var("SHOW TABLES LIKE '$db_table_name'") != $db_table_name) {
        if (!empty($wpdb->charset))
            $charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";

        if (!empty($wpdb->collate))
            $charset_collate .= " COLLATE $wpdb->collate";

        $sql = "CREATE TABLE $db_table_name (
    		id mediumint(9) NOT NULL AUTO_INCREMENT,
    		purchaseCode VARCHAR(250) NOT NULL,      
    		colorWinHeader VARCHAR(16) NOT NULL DEFAULT '#ecf0f1',       
    		colorWinHeaderBg VARCHAR(16) NOT NULL DEFAULT '#1abc9c',     
    		colorWinIconsBg VARCHAR(16) NOT NULL DEFAULT '#ecf0f1',     
    		colorWinIcons VARCHAR(16) NOT NULL DEFAULT '#95a5a6',    
    		colorWinIconsSelected VARCHAR(16) NOT NULL DEFAULT '#95a5a6',     
    		colorWPMenuLinks VARCHAR(16) NOT NULL DEFAULT '#1cccaa',         
    		colorWPMenuBadges VARCHAR(16) NOT NULL DEFAULT '#e74c3c',      
    		colorShortcuts VARCHAR(16) NOT NULL DEFAULT '#ecf0f1',       
                colorContextmenuBg VARCHAR(16) NOT NULL DEFAULT '#34495e', 
                colorContextmenuLinks VARCHAR(16) NOT NULL DEFAULT '#ffffff',   
                colorContextmenuLinksHover VARCHAR(16) NOT NULL DEFAULT '#1cccaa',                   
    		enableWOS BOOL NOT NULL DEFAULT 1,     
    		fxWinGray BOOL NOT NULL DEFAULT 1,      
    		fxWinBlur BOOL NOT NULL DEFAULT 1,      
    		fxWinDark BOOL NOT NULL DEFAULT 1,          
                applyColorsWP BOOL NOT NULL DEFAULT 1,
                firstStart BOOL NOT NULL DEFAULT 1,
                backgroundImage VARCHAR(250) NOT NULL,
                hideWPMenu BOOL NOT NULL,           
                rolesAllowed TEXT NOT NULL,
                usersCanEditShortcut BOOL NOT NULL DEFAULT 1, 
                key_nextWin_1 VARCHAR(16) NOT NULL DEFAULT 'alt', 
                key_nextWin_2 VARCHAR(4) NOT NULL DEFAULT 's',
                key_prevWin_1 VARCHAR(16) NOT NULL DEFAULT 'alt', 
                key_prevWin_2 VARCHAR(16) NOT NULL DEFAULT 'shift',
                key_prevWin_3 VARCHAR(4) NOT NULL DEFAULT 's',
                usersCanChangeStyles BOOL NOT NULL DEFAULT 1,
                useVideoBackground BOOL NOT NULL DEFAULT 0,
                backgroundVideo VARCHAR(250) NOT NULL,
                colorBottomBar VARCHAR(16) NOT NULL DEFAULT '#000000', 
                colorBottomAlpha FLOAT NOT NULL DEFAULT 0.7,             
                colorBg VARCHAR(16) NOT NULL DEFAULT '#2c3e50',                    
                useAdminSkin BOOL NOT NULL DEFAULT 1,        
                skin_topBarColorBg VARCHAR(16) NOT NULL DEFAULT '#34495e', 
                skin_topBarLinksColorBg VARCHAR(16) NOT NULL DEFAULT '#34495e', 
                skin_topBarLinksColorBgHover VARCHAR(16) NOT NULL DEFAULT '#22313F', 
                skin_topBarLinksColor VARCHAR(16) NOT NULL DEFAULT '#ecf0f1', 
                skin_topBarLinksColorHover VARCHAR(16) NOT NULL DEFAULT '#ffffff', 
                skin_topBarLinksColorSubmenu VARCHAR(16) NOT NULL DEFAULT '#ffffff', 
                skin_topBarLinksColorSubmenuHover VARCHAR(16) NOT NULL DEFAULT '#1cccaa', 
                skin_sideBarColorBg VARCHAR(16) NOT NULL DEFAULT '#34495e', 
                skin_sideBarLinksColorBg VARCHAR(16) NOT NULL DEFAULT '#34495e', 
                skin_sideBarLinksColorBgHover VARCHAR(16) NOT NULL DEFAULT '#22313F', 
                skin_sideBarLinksColorSubmenu VARCHAR(16) NOT NULL DEFAULT '#ecf0f1', 
                skin_sideBarLinksColorSubmenuActive VARCHAR(16) NOT NULL DEFAULT '#ffffff', 
                skin_sideBarHeaderColorSubmenuActiveBg VARCHAR(16) NOT NULL DEFAULT '#1abc9c', 
                skin_sideBarHeaderColorSubmenuActive VARCHAR(16) NOT NULL DEFAULT '#ffffff', 
                skin_sideBarLinksColorSubmenuHover VARCHAR(16) NOT NULL DEFAULT '#1cccaa', 
                skin_sideBarLinksColor VARCHAR(16) NOT NULL DEFAULT '#ecf0f1', 
                skin_sideBarLinksColorHover VARCHAR(16) NOT NULL DEFAULT '#ffffff',                                 
                skin_googleFont VARCHAR(250) NOT NULL DEFAULT 'Work Sans', 
                skin_colorBtnPrimary VARCHAR(16) NOT NULL DEFAULT '#ffffff', 
                skin_colorBtnPrimaryBg VARCHAR(16) NOT NULL DEFAULT '#1abc9c', 
                skin_colorBtnSecondary VARCHAR(16) NOT NULL DEFAULT '#ffffff', 
                skin_colorBtnSecondaryBg VARCHAR(16) NOT NULL DEFAULT '#f39c12', 
                skin_colorBtnDefault VARCHAR(16) NOT NULL DEFAULT '#ffffff', 
                skin_colorBtnDefaultBg VARCHAR(16) NOT NULL DEFAULT '#bdc3c7', 
                skin_pageBg VARCHAR(16) NOT NULL DEFAULT '#ecf0f1', 
                skin_linksColor VARCHAR(16) NOT NULL DEFAULT '#1abc9c', 
                skin_headersColor VARCHAR(16) NOT NULL DEFAULT '#ffffff', 
                skin_headersColorBg VARCHAR(16) NOT NULL DEFAULT '#34495e',                 

                login_useVideoBackground BOOL NOT NULL DEFAULT 0,
                login_backgroundVideo VARCHAR(250) NOT NULL,
                login_backgroundImage VARCHAR(250) NOT NULL, 
                login_colorBg VARCHAR(16) NOT NULL DEFAULT '#2c3e50',  
                login_mainColor VARCHAR(16) NOT NULL DEFAULT '#1abc9c',    
                login_panelColor VARCHAR(16) NOT NULL DEFAULT '#ffffff',  
                login_panelColorBg VARCHAR(16) NOT NULL DEFAULT '#34495e',  
                login_linksColor VARCHAR(16) NOT NULL DEFAULT '#1abc9c',   
                login_buttonColor VARCHAR(16) NOT NULL DEFAULT '#ffffff',   
                login_buttonColorBg VARCHAR(16) NOT NULL DEFAULT '#1abc9c',    
                login_logo VARCHAR(250) NOT NULL DEFAULT '".esc_url(trailingslashit(plugins_url('/assets/', __FILE__)))."img/businessman-256.png',   
                showNotifications BOOL NOT NULL DEFAULT 0,
		UNIQUE KEY id (id)
		) $charset_collate;";

        dbDelta($sql);
        $rows_affected = $wpdb->insert($db_table_name, array('purchaseCode' => '',
            'colorWinHeader'=>'#ecf0f1',
            'colorWinHeaderBg'=>'#1cccaa',
            'colorWinIconsBg'=>'#ecf0f1',
            'colorWinIcons'=>'#95a5a6',
            'colorWinIconsSelected'=>'#95a5a6',
            'colorWPMenuLinks'=>'#1cccaa',
            'colorWPMenuBadges'=>'#1cccaa',
            'colorShortcuts'=>'#ecf0f1',
            'colorContextmenuBg'=>'#34495e',
            'colorContextmenuLinks'=>'#ffffff',
            'colorContextmenuLinksHover'=>'#1cccaa',
            'usersCanEditShortcut'=>1,
            'key_nextWin_1'=>'alt',
            'key_nextWin_2'=>'s',
            'key_prevWin_1'=>'alt',
            'key_prevWin_2'=>'shift',
            'key_prevWin_3'=>'s')
            );
    }
    
    $db_table_name = $wpdb->prefix . "wos_shortcuts";
    if ($wpdb->get_var("SHOW TABLES LIKE '$db_table_name'") != $db_table_name) {
        if (!empty($wpdb->charset))
            $charset_collate = "DEFAULT CHARACTER SET $wpdb->charset";

        if (!empty($wpdb->collate))
            $charset_collate .= " COLLATE $wpdb->collate";

        $sql = "CREATE TABLE $db_table_name (
    		id mediumint(9) NOT NULL AUTO_INCREMENT,
    		userID mediumint(9) NOT NULL,      
    		posX  mediumint(9) NOT NULL,    
    		posY  mediumint(9) NOT NULL,  
                url VARCHAR(250) NOT NULL,
                html TEXT NOT NULL,
		UNIQUE KEY id (id)
		) $charset_collate;";

        dbDelta($sql);
    }
    
    global $isInstalled;
    $isInstalled = true;
    wp_redirect("wp-admin/admin.php?page=wos_menu&wos-reload=1");
}
// End install()

/**
 * Update database
 * @access  public
 * @since   2.0
 * @return  void
 */
function wos_checkDBUpdates($version) {
    global $wpdb;
    $installed_ver = get_option("wos_version");
    require_once(ABSPATH . '/wp-admin/includes/upgrade.php');
    
    if (!$installed_ver || $installed_ver < 1.1) {      
         $table_name = $wpdb->prefix . "wos_settings";      
        $sql = "ALTER TABLE " . $table_name . " ADD hideWPMenu BOOL NOT NULL;";
        $wpdb->query($sql);            
    }
    
    if (!$installed_ver || $installed_ver < 1.12) {      
         $table_name = $wpdb->prefix . "wos_settings";      
        $sql = "ALTER TABLE " . $table_name . " ADD rolesAllowed TEXT NOT NULL;";
        $wpdb->query($sql);            
    }    
    if (!$installed_ver || $installed_ver < 1.132) {      
         $table_name = $wpdb->prefix . "wos_settings";      
        $sql = "ALTER TABLE " . $table_name . " ADD usersCanEditShortcut BOOL NOT NULL DEFAULT 1;";
        $wpdb->query($sql);            
        $wpdb->update($table_name, array('usersCanEditShortcut'=>1), array('id' => 1));
        
    }                
            
    if (!$installed_ver || $installed_ver < 1.137) {     
         $table_name = $wpdb->prefix . "wos_settings";      
        $sql = "ALTER TABLE " . $table_name . " ADD key_nextWin_1 VARCHAR(16) NOT NULL DEFAULT 'alt';";
        $wpdb->query($sql);            
        $sql = "ALTER TABLE " . $table_name . " ADD key_nextWin_2 VARCHAR(4) NOT NULL DEFAULT 's';";
        $wpdb->query($sql);            
        $sql = "ALTER TABLE " . $table_name . " ADD key_prevWin_1 VARCHAR(16) NOT NULL DEFAULT 'alt';";
        $wpdb->query($sql);            
        $sql = "ALTER TABLE " . $table_name . " ADD key_prevWin_2 VARCHAR(16) NOT NULL DEFAULT 'shift';";
        $wpdb->query($sql);            
        $sql = "ALTER TABLE " . $table_name . " ADD key_prevWin_3 VARCHAR(4) NOT NULL DEFAULT 's';";
        $wpdb->query($sql);            
        
    }    
    if (!$installed_ver || $installed_ver < 1.144) {   
         $table_name = $wpdb->prefix . "wos_settings";      
        $sql = "ALTER TABLE " . $table_name . " ADD usersCanChangeStyles BOOL NOT NULL DEFAULT 1;";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD colorContextmenuBg VARCHAR(16) NOT NULL DEFAULT '#34495e';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD colorContextmenuLinks VARCHAR(16) NOT NULL DEFAULT '#ffffff';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD colorContextmenuLinksHover VARCHAR(16) NOT NULL DEFAULT '#1cccaa';";
        $wpdb->query($sql);   
        $sql = "ALTER TABLE " . $table_name . " ADD useVideoBackground BOOL NOT NULL DEFAULT 0;";
        $wpdb->query($sql);   
        $sql = "ALTER TABLE " . $table_name . " ADD backgroundVideo VARCHAR(250) NOT NULL;";
        $wpdb->query($sql);                 
        $sql = "ALTER TABLE " . $table_name . " ADD colorBottomBar VARCHAR(16) NOT NULL DEFAULT '#000000';";
        $wpdb->query($sql);                 
        $sql = "ALTER TABLE " . $table_name . " ADD colorBottomAlpha FLOAT NOT NULL DEFAULT 0.7;";
        $wpdb->query($sql);            
        $sql = "ALTER TABLE " . $table_name . " ADD colorBg VARCHAR(16) NOT NULL DEFAULT '#2c3e50';";
        $wpdb->query($sql);    
    }
    if (!$installed_ver || $installed_ver < 1.145) {   
         $table_name = $wpdb->prefix . "wos_settings";      
        $sql = "ALTER TABLE " . $table_name . " ADD useAdminSkin BOOL NOT NULL DEFAULT 1;";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_topBarColorBg VARCHAR(16) NOT NULL DEFAULT '#34495e';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_topBarLinksColorBg VARCHAR(16) NOT NULL DEFAULT '#34495e';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_topBarLinksColorBgHover VARCHAR(16) NOT NULL DEFAULT '#22313F';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_topBarLinksColor VARCHAR(16) NOT NULL DEFAULT '#ecf0f1';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_topBarLinksColorHover VARCHAR(16) NOT NULL DEFAULT '#ffffff';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_topBarLinksColorSubmenu VARCHAR(16) NOT NULL DEFAULT '#ffffff';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_topBarLinksColorSubmenuHover VARCHAR(16) NOT NULL DEFAULT '#1cccaa';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_sideBarColorBg VARCHAR(16) NOT NULL DEFAULT '#34495e';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_sideBarLinksColorBg VARCHAR(16) NOT NULL DEFAULT '#34495e';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_sideBarLinksColorBgHover VARCHAR(16) NOT NULL DEFAULT '#22313F';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_sideBarLinksColorSubmenu VARCHAR(16) NOT NULL DEFAULT '#ecf0f1';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_sideBarLinksColorSubmenuActive VARCHAR(16) NOT NULL DEFAULT '#ffffff';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_sideBarHeaderColorSubmenuActiveBg VARCHAR(16) NOT NULL DEFAULT '#1abc9c';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_sideBarHeaderColorSubmenuActive VARCHAR(16) NOT NULL DEFAULT '#ffffff';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_sideBarLinksColorSubmenuHover VARCHAR(16) NOT NULL DEFAULT '#1cccaa';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_sideBarLinksColor VARCHAR(16) NOT NULL DEFAULT '#ecf0f1';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_sideBarLinksColorHover VARCHAR(16) NOT NULL DEFAULT '#ffffff';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_googleFont VARCHAR(250) NOT NULL DEFAULT 'Work Sans';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_colorBtnPrimary VARCHAR(16) NOT NULL DEFAULT '#ffffff';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_colorBtnPrimaryBg VARCHAR(16) NOT NULL DEFAULT '#1abc9c';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_colorBtnSecondary VARCHAR(16) NOT NULL DEFAULT '#ffffff';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_colorBtnSecondaryBg VARCHAR(16) NOT NULL DEFAULT '#f39c12';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_colorBtnDefault VARCHAR(16) NOT NULL DEFAULT '#ffffff';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_colorBtnDefaultBg VARCHAR(16) NOT NULL DEFAULT '#bdc3c7';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_pageBg VARCHAR(16) NOT NULL DEFAULT '#ecf0f1';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_linksColor VARCHAR(16) NOT NULL DEFAULT '#1abc9c';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_headersColor VARCHAR(16) NOT NULL DEFAULT '#ffffff';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD skin_headersColorBg VARCHAR(16) NOT NULL DEFAULT '#34495e';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD login_useVideoBackground BOOL NOT NULL DEFAULT 0;";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD login_backgroundVideo VARCHAR(250) NOT NULL;";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD login_backgroundImage VARCHAR(250) NOT NULL;";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD login_colorBg VARCHAR(16) NOT NULL DEFAULT '#2c3e50';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD login_mainColor VARCHAR(16) NOT NULL DEFAULT '#1abc9c';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD login_panelColor VARCHAR(16) NOT NULL DEFAULT '#ffffff';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD login_panelColorBg VARCHAR(16) NOT NULL DEFAULT '#34495e';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD login_linksColor VARCHAR(16) NOT NULL DEFAULT '#1abc9c';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD login_buttonColor VARCHAR(16) NOT NULL DEFAULT '#ffffff';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD login_buttonColorBg VARCHAR(16) NOT NULL DEFAULT '#1abc9c';";
        $wpdb->query($sql);     
        $sql = "ALTER TABLE " . $table_name . " ADD login_logo VARCHAR(250) NOT NULL DEFAULT '".esc_url(trailingslashit(plugins_url('/assets/', __FILE__)))."img/businessman-256.png';";
        $wpdb->query($sql);   
    }
    
    if (!$installed_ver || $installed_ver < 1.149) {   
         $table_name = $wpdb->prefix . "wos_settings";      
        $sql = "ALTER TABLE " . $table_name . " ADD  showNotifications BOOL NOT NULL DEFAULT 0;";
        $wpdb->query($sql);     
    }
    
    
    
    update_option("wos_version", $version);
}

/**
 * Uninstallation.
 * @access  public
 * @since   1.0.0
 * @return  void
 */
function wos_uninstall() {

    global $wpdb;
    global $jal_db_version;
    $table_name = $wpdb->prefix . "wos_settings";
    $wpdb->query("DROP TABLE IF EXISTS $table_name");
    $table_name = $wpdb->prefix . "wos_shortcuts";
    $wpdb->query("DROP TABLE IF EXISTS $table_name");
    $userID = get_current_user_id(); 
    delete_user_option($userID,'colorWinHeader');
    delete_user_option($userID,'colorWinHeaderBg');
    delete_user_option($userID,'colorWinIconsBg');
    delete_user_option($userID,'colorWinIcons');
    delete_user_option($userID,'colorWinIconsSelected');
    delete_user_option($userID,'colorWPMenuLinks');
    delete_user_option($userID,'colorWPMenuBadges');
    delete_user_option($userID,'colorShortcuts');
    delete_user_option($userID,'colorContextmenuBg');
    delete_user_option($userID,'colorContextmenuLinks');
    delete_user_option($userID,'colorContextmenuLinksHover');
    delete_user_option($userID,'colorBg');
    delete_user_option($userID,'fxWinGray');
    delete_user_option($userID,'fxWinBlur');
    delete_user_option($userID,'fxWinDark');
    delete_user_option($userID,'backgroundImage');
    delete_user_option($userID,'useVideoBackground');
    delete_user_option($userID,'backgroundVideo');
    delete_user_option($userID,'colorBottomBar');
    delete_user_option($userID,'colorBottomAlpha');       
    
}
// End uninstall()

wos_osBackendDesktop();